ClassicPremadeFrame = CreateFrame("Frame");

local DEFAULT_JOIN_TEXT = "加入战斗";

local BNET_FRIENDS = {};
local BNET_QUERY_CD = 0;
local SET_SERVERTIME = 0;
local LINKED_QUEUE = false;

local QUEUE_TIME = 0;
local READY_CHECK = 0;
local MAX_DELAY = 0;
local NOT_READY = {};

local ClassicPremadeEvents = {};

local READY_CHECK_COOLDOWN = 0;
local QUEUE_COOLDOWN = 0;

local SOUND_PLAYED = false;

function ClassicPremade_GetLag()
  local down, up, lagHome, lagWorld = GetNetStats();
  return lagWorld / 1000;
end

function ClassicPremade_HandleLinkedQueue()
  if(SET_SERVERTIME > GetServerTime() and LINKED_QUEUE) then
    return;
  elseif(LINKED_QUEUE) then
    SET_SERVERTIME = 0;
    LINKED_QUEUE = false;
    QUEUE_TIME = GetTime() + 7 - ClassicPremade_GetLag();
    print("[ClassicPremade] 排队开始： " .. floor((7 - ClassicPremade_GetLag()) * 100 + 0.5) / 100 .. "秒");
    SOUND_PLAYED = false;
    BattlefieldFrameJoinButton:SetEnabled(false);
  end
  if(not SOUND_PLAYED and QUEUE_TIME - GetTime() < 1) then
    SOUND_PLAYED = true;
    PlaySound(8959);
  end
  if(QUEUE_TIME < GetTime()) then
    ClassicPremadeFrame:SetScript("OnUpdate", nil);
    BattlefieldFrameJoinButton:SetEnabled(true);
    QUEUE_TIME = 0;
    BattlefieldFrameJoinButton:SetText(DEFAULT_JOIN_TEXT);
    ClassicPremadeQueueButton:SetEnabled(true);
  else
    BattlefieldFrameJoinButton:SetText(floor((QUEUE_TIME - GetTime()) * 10) / 10);
  end
end

function ClassicPremade_HandleQueue()
  if(not SOUND_PLAYED and QUEUE_TIME - GetTime() < 1) then
    SOUND_PLAYED = true;
    PlaySound(8959);
  end
  if(QUEUE_TIME < GetTime()) then
    ClassicPremadeFrame:SetScript("OnUpdate", nil);
    BattlefieldFrameJoinButton:SetEnabled(true);
    QUEUE_TIME = 0;
    BattlefieldFrameJoinButton:SetText(DEFAULT_JOIN_TEXT);
    ClassicPremadeQueueButton:SetEnabled(true);
  else
    BattlefieldFrameJoinButton:SetText(floor((QUEUE_TIME - GetTime()) * 10) / 10);
  end
end

function ClassicPremade_IsReady()
  --strfind(BattlefieldFrameZoneDescription:GetText(), "Alterac") ~= nil and
  return BattlefieldFrame:IsVisible();
end

function ClassicPremade_ReadyCheck()
  local group = ClassicPremade_GroupType();
  NOT_READY = {};
  for i = 1, GetNumGroupMembers() do
    local name = UnitName(group .. i);
    if(name ~= nil) then
      NOT_READY[name] = true;
    end
  end
end

function ClassicPremade_PerformReadyCheck(sender)
  if(not ClassicPremade_PlayerIsLeader(sender) or READY_CHECK > 0) then
    return;
  end
  READY_CHECK = GetTime();
  ClassicPremade_ReadyCheck();
  if(ClassicPremade_IsReady()) then
    C_ChatInfo.SendAddonMessage("CPREM-R", ClassicPremade_GetLag(), strupper(ClassicPremade_GroupType()));
    HAS_SENT_READY = true;
  end
  ClassicPremadeFrame:SetScript("OnUpdate", ClassicPremade_HandleReadyCheck);
  print("[ClassicPremade] 就绪检查已开始");
  PlaySound(8960);
end

function ClassicPremade_HandleReadyCheck()
  if(READY_CHECK + 7 < GetTime()) then
    ClassicPremadeFrame:SetScript("OnUpdate", nil);
    ClassicPremadeReadyButton:SetEnabled(true);
    READY_CHECK = 0;
    local notReadyPlayers = "";
    for k, v in pairs(NOT_READY) do
      if(notReadyPlayers ~= "") then
        notReadyPlayers = notReadyPlayers .. ", ";
      end
      notReadyPlayers = notReadyPlayers .. k;
    end
    notReadyPlayers = notReadyPlayers .. ".";
    if(notReadyPlayers == ".") then
      print("[ClassicPremade] 所有人都已就绪");
    else
      print("[ClassicPremade] 未就绪:");
      print(notReadyPlayers);
    end
  end
end

function ClassicPremade_Queue(sender, delay)
  if(not ClassicPremade_PlayerIsLeader(sender)) then
    return;
  end
  local adjustedDelay = delay - ClassicPremade_GetLag();
  print("[ClassicPremade] 排队开始： " .. floor((adjustedDelay) * 100 + 0.5) / 100 .. "秒");
  SOUND_PLAYED = false;
  BattlefieldFrameJoinButton:SetEnabled(false);
  QUEUE_TIME = GetTime() + adjustedDelay;
  ClassicPremadeFrame:SetScript("OnUpdate", ClassicPremade_HandleQueue);
end

function ClassicPremade_PlayerIsLeader(sender)
  if(UnitIsGroupLeader("player")) then
    return UnitName("player") == sender;
  end
  local group = ClassicPremade_GroupType();
  for i = 1, GetNumGroupMembers() do
    if(UnitIsGroupLeader(group .. i)) then
      return UnitName(group ..i) == sender;
    end
  end
  return false;
end

function ClassicPremade_GroupType()
  return IsInRaid() and "raid" or "party";
end

function ClassicPremade_PlayersAreReady()
  for k,v in pairs(NOT_READY) do
    if(v ~= nil) then
      return false;
    end
  end
  return true;
end

function ClassicPremade_BnetMap()
  BNET_FRIENDS = {};
  for i=1, BNGetNumFriends() do
    local presenceID, _, _, _, toonID, _, isOnline, _, _, _, _, _, _, _  = BNGetFriendInfo(i);
    if(isOnline and toonID ~= nil) then
      BNET_FRIENDS[strlower(toonID)] = presenceID;
    end
  end
end

function ClassicPremade_GetMessageData(msg)
  if(strfind(msg, "[ClassicPremade]")) then
    local _, num, _ = strsplit(" ", msg);
    num = tonumber(num);
    if(num ~= nil) then
      if(num > GetServerTime()) then
        return num;
      end
    end
  end
  return nil;
end

function ClassicPremade_MessageByName(name, msg)
  if(strfind(name, "!")) then
    local name = gsub(name, "!", "");
    SendChatMessage(msg, "WHISPER", nil, name);
    return;
  end
  if(BNET_FRIENDS[strlower(name)] ~= nil) then
    BNSendWhisper(BNET_FRIENDS[strlower(name)], msg);
  else
    SendChatMessage(msg, "WHISPER" , nil, name);
  end

end

function ClassicPremade_ShowWhisperGUI(bool)
  if(bool) then
    ClassicPremade_ShowBNetTexture(NetworkMasterInput:GetText());
    NetworkSlavesInput:Show();
    NetworkSlaves:Show();
    NetworkMasterInput:Show();
    NetworkMaster:Show();
  else
    BattlefieldFrameBNetTexture:Hide();
    NetworkSlavesInput:Hide();
    NetworkSlaves:Hide();
    NetworkMasterInput:Hide();
    NetworkMaster:Hide();
  end
end

function ClassicPremadeEvents:CHAT_MSG_ADDON(arg1, arg2, arg3, arg4, ...)
  arg4, _ = strsplit("-", arg4);
  if(arg1 == "CPREM-RC") then
    ClassicPremade_PerformReadyCheck(arg4);
  elseif(arg1 == "CPREM-R") then
    if(READY_CHECK > 0) then
      arg2 = tonumber(arg2);
      if(arg2 == nil) then
        print("[ClassicPremade] 插件过期: " .. arg4);
        return
      end
      NOT_READY[arg4] = nil;
      local delay = arg2 - ClassicPremade_GetLag();
      if(MAX_DELAY < delay) then
        MAX_DELAY = delay;
      end
      if(ClassicPremade_PlayersAreReady()) then
        READY_CHECK = 0;
      end
    end
  elseif(arg1 == "CPREM-Q") then
    arg2 = tonumber(arg2);
    if(arg2 ~= nil) then
      if(arg2 < 15) then
        ClassicPremade_Queue(arg4, arg2);
      end
    end
  end
end

function ClassicPremadeEvents:CHAT_MSG_BN_WHISPER(msg, author)
  if(strlower(author) == strlower(NetworkMasterInput:GetText())) then
    local time = ClassicPremade_GetMessageData(msg);
    if(time ~= nil) then
      SET_SERVERTIME = time;
      LINKED_QUEUE = true;
      ClassicPremadeFrame:SetScript("OnUpdate", ClassicPremade_HandleLinkedQueue);
      print("[ClassicPremade] 准备排队");
    end
  end
end

function ClassicPremadeEvents:CHAT_MSG_WHISPER(msg, author)
  local author,_ = strsplit("-", author);
  if(strlower(author) == strlower(gsub(NetworkMasterInput:GetText(), "!", ""))) then
    local time = ClassicPremade_GetMessageData(msg);
    if(time ~= nil) then
      SET_SERVERTIME = time;
      LINKED_QUEUE = true;
      ClassicPremadeFrame:SetScript("OnUpdate", ClassicPremade_HandleLinkedQueue);
      print("[ClassicPremade] 准备排队");
    end
  end
end

ClassicPremadeFrame:SetScript("OnEvent", function(self, event, ...)
  ClassicPremadeEvents[event](self, ...);
end);
for k, v in pairs(ClassicPremadeEvents) do
  ClassicPremadeFrame:RegisterEvent(k);
end

C_ChatInfo.RegisterAddonMessagePrefix("CPREM-RC");
C_ChatInfo.RegisterAddonMessagePrefix("CPREM-R");
C_ChatInfo.RegisterAddonMessagePrefix("CPREM-Q");

local b = CreateFrame("Button", "ClassicPremadeQueueButton", BattlefieldFrame, "UIPanelButtonTemplate")
b:SetSize(100, 24);
b:SetText("队列排队");
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35, 50);
b:SetScript("OnClick", function()
  if(ClassicPremadeWhisperCheckbox:GetChecked()) then
    if(strlen(NetworkSlavesInput:GetText()) > 2 and QUEUE_COOLDOWN < GetTime()) then
      QUEUE_COOLDOWN = GetTime() + 15;
      local t = NetworkSlavesInput:GetText();
      local time = GetServerTime() + 8;
      local msg = "[ClassicPremade] " .. time;
      ClassicPremade_BnetMap();
      SET_SERVERTIME = time;
      LINKED_QUEUE = true;
      ClassicPremadeFrame:SetScript("OnUpdate", ClassicPremade_HandleLinkedQueue);
      ClassicPremadeQueueButton:SetEnabled(false);
      print("[ClassicPremade] 准备排队");
      if(strfind(t, " ")) then
        for name in string.gmatch(t, "%S+") do
          ClassicPremade_MessageByName(name, msg);
        end
      else
        ClassicPremade_MessageByName(t, msg);
      end
      return;
    end
  end
  if(ClassicPremade_PlayerIsLeader(UnitName("player")) and QUEUE_COOLDOWN < GetTime()) then
    QUEUE_COOLDOWN = GetTime() + 15;
    local delay = 1 + MAX_DELAY;
    if(delay < 3) then
      delay = 3;
    end
    C_ChatInfo.SendAddonMessage("CPREM-Q", delay, strupper(ClassicPremade_GroupType()));
    ClassicPremadeQueueButton:SetEnabled(false);
  end
end)

local b = CreateFrame("Button", "ClassicPremadeReadyButton", BattlefieldFrame, "UIPanelButtonTemplate")
b:SetSize(100, 24);
b:SetText("就需检查");
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35 - 100, 50);
b:SetScript("OnClick", function()
  if(ClassicPremade_PlayerIsLeader(UnitName("player")) and READY_CHECK_COOLDOWN < GetTime()) then
    READY_CHECK_COOLDOWN = GetTime() + 8;
    C_ChatInfo.SendAddonMessage("CPREM-RC", ClassicPremade_GetLag(), strupper(ClassicPremade_GroupType()));
    ClassicPremadeReadyButton:SetEnabled(false);
  end
end)

local b = BattlefieldFrame:CreateFontString("NetworkMaster", "OVERLAY")
b:SetFont("Fonts\\ARHei.TTF", 20, "OUTLINE");
b:SetJustifyH("LEFT");
b:SetSize(100, 24);
b:SetText("Master");
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35 - 150, 26);

function ClassicPremade_ShowBNetTexture(str)
  if(str ~= nil) then
    if(BNET_FRIENDS[strlower(str)] ~= nil) then
      BattlefieldFrameBNetTexture:Show();
      return;
    end
  end
  BattlefieldFrameBNetTexture:Hide();
end

local b = CreateFrame("EditBox", "NetworkMasterInput", BattlefieldFrame, "InputBoxTemplate");
b:SetText("");
b:SetWidth(150);
b:SetHeight(24);
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35 - 5, 26);
b:SetAutoFocus(false);
b:SetMaxLetters(30);
b:SetScript("OnEnterPressed", function()
	b:ClearFocus();
end);
b:SetScript("OnTextChanged", function()
  if(BNET_QUERY_CD < GetTime()) then
    BNET_QUERY_CD = GetTime() + 30;
    ClassicPremade_BnetMap();
  end
  ClassicPremade_ShowBNetTexture(NetworkMasterInput:GetText());
end);


local b = BattlefieldFrame:CreateFontString("NetworkSlaves", "OVERLAY")
b:SetFont("Fonts\\ARHei.TTF", 20, "OUTLINE");
b:SetJustifyH("LEFT");
b:SetSize(100, 24);
b:SetText("小号");
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35 - 150, 0);

local b = CreateFrame("EditBox", "NetworkSlavesInput", BattlefieldFrame, "InputBoxTemplate");
b:SetText("");
b:SetWidth(500);
b:SetHeight(24);
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35 - 5 + 350, 0);
b:SetAutoFocus(false);
b:SetMaxLetters(9999);
b:SetScript("OnEnterPressed", function()
	b:ClearFocus();
end);

local b = BattlefieldFrame:CreateTexture("BattlefieldFrameBNetTexture", "BACKGROUND");
b:SetSize(24, 24);
b:SetPoint("BOTTOMRIGHT", BattlefieldFrame, "BOTTOMRIGHT", -35 - 5 + 28, 26);
b:SetTexture("Interface\\FriendsFrame\\Battlenet-Portrait");

local b = CreateFrame("CheckButton", "ClassicPremadeWhisperCheckbox", BattlefieldFrame, "ChatConfigCheckButtonTemplate")
b:SetSize(24, 24);
b:SetText("私聊模式");
b.tooltip = "如果要使用跨服务器/非组模式，请选中此项.";
b:SetPoint("BOTTOMLEFT", BattlefieldFrame, "BOTTOMLEFT", 20, 76);
b:SetScript("OnClick", function()
  if(ClassicPremadeWhisperCheckbox:GetChecked()) then
    ClassicPremade_ShowWhisperGUI(true);
  else
    ClassicPremade_ShowWhisperGUI(false);
  end
end)
local b = BattlefieldFrame:CreateFontString("ClassicPremadeWhisperCheckboxLabel", "OVERLAY")
b:SetFont("Fonts\\ARHei.TTF", 14, "OUTLINE");
b:SetJustifyH("LEFT");
b:SetSize(100, 24);
b:SetText("私聊");
b:SetPoint("BOTTOMLEFT", BattlefieldFrame, "BOTTOMLEFT", 44, 76);
ClassicPremade_ShowWhisperGUI(false);
DEFAULT_JOIN_TEXT = BattlefieldFrameJoinButton:GetText();
